USE Obfuscation

IF OBJECT_ID( 'pObfuscateData' ) IS NOT NULL
    DROP PROCEDURE pObfuscateData;

GO

CREATE PROCEDURE pObfuscateData
AS
    SET NOCOUNT ON;
    
    DECLARE @statement NVARCHAR(MAX);

    -- regenerate the obfuscation statement for any table that needs it
    EXEC pGenerateObfuscationStatements;

    DECLARE ObfStatements CURSOR FAST_FORWARD FOR
        SELECT ObfStatement
        FROM teObfuscationTable;

    OPEN ObfStatements

    -- cycle through all the tables and run the obfuscation statement for each one
    WHILE 1=1
    BEGIN
        FETCH NEXT 
            FROM ObfStatements
            INTO @statement

        IF @@FETCH_STATUS <> 0
            BREAK;

        EXEC sp_executesql @statement;
    END

    CLOSE ObfStatements
    DEALLOCATE ObfStatements
GO